% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_by.R
\name{split_by}
\alias{split_by}
\alias{split_by_var}
\alias{split_by_condition}
\title{Split Data Frame by Variable Expressions or Condition}
\usage{
split_by_var(data_frame, variable)

split_by_condition(data_frame, ..., inverse = FALSE)
}
\arguments{
\item{data_frame}{A data frame which should be split up into multiple data frames.}

\item{variable}{In \code{\link[=split_by_var]{split_by_var()}} pass in a variable name which expressions
are used for splitting up the data frame.}

\item{...}{In \code{\link[=split_by_condition]{split_by_condition()}} pass in one or multiple conditions on which
the provided data frame should be splitted.}

\item{inverse}{In \code{\link[=split_by_condition]{split_by_condition()}} if only one condition is provided, the
data frame can be split into two parts. The second returned data frame will be the
inverse group of the first.}
}
\value{
\code{\link[=split_by_var]{split_by_var()}}: Returns a list of data frames split by variable expressions.
The lists names are the variable expressions.

\code{\link[=split_by_condition]{split_by_condition()}}: Returns a list of data frames split conditionally.
The lists names are the conditions.
}
\description{
Split up a data frame based on variable expressions or on conditions to receive
multiple smaller data frames.
}
\details{
\code{\link[=split_by]{split_by()}} is based on the explicit Output from 'SAS'. With the Output function
one can - among other things - explicitly tell 'SAS' which observation to output into
which data set. Which enables the user to output one observation into one or multiple
data sets.

Instead of subsetting the same data frame multiple times manually, you can subset it
multiple times at once with this function.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Split by variable expressions
split_var_df <- my_data |> split_by_var(sex)

# Split by conditions
split_cond_df <- my_data |> split_by_condition(sex == 1 & age <  18,
                                               sex == 2 & age >= 18)

# Split by condition with inverse group
split_inv_df <- my_data |> split_by_condition(sex == 1, inverse = TRUE)

}
