% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_helpers.R
\name{get_excel_range}
\alias{get_excel_range}
\title{Converts Numbers into 'Excel' Ranges}
\usage{
get_excel_range(
  row = NULL,
  column = NULL,
  from_row = NULL,
  from_column = NULL,
  to_row = NULL,
  to_column = NULL
)
}
\arguments{
\item{row}{Single row number.}

\item{column}{Single column number.}

\item{from_row}{Range start row.}

\item{from_column}{Range start column.}

\item{to_row}{Range end row.}

\item{to_column}{Range end column.}
}
\value{
Returns a character with an 'Excel' range.
}
\description{
Converts a column number into the according letter to form a cell reference
like it is used in 'Excel' (e.g "A1"). Also can compute a range from cell to
cell (e.g. "A1:BY22").
}
\examples{
single_cell <- get_excel_range(row = 1, column = 6)
range       <- get_excel_range(from_row = 1, from_column = 6,
                                 to_row = 5,   to_column = 35)

}
