% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calculation.R
\name{contrast1D}
\alias{contrast1D}
\title{Computes power of t-test for one-dimensional contrast matrices}
\usage{
contrast1D(
  object,
  L,
  method = c("Satterthwaite"),
  sig.level = 0.05,
  alternative = c("two.sided", "one.sided"),
  strict = TRUE
)
}
\arguments{
\item{object}{design object}

\item{L}{contrast vector}

\item{method}{DF approximation method, only "Satterthwaite" available currently}

\item{sig.level}{significance level, default 0.05}

\item{alternative}{one- or two-sided test}

\item{strict}{whether or not use strict interpretation in two-sided case}
}
\value{
A data frame with columns for effect size, degrees of freedom, significance level, power, and test type.
}
\description{
Computes power of t-test for one-dimensional contrast matrices
}
\keyword{functions}
\keyword{internal}
\keyword{lmerTest}
\keyword{modified}
