% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscales.R
\name{scale_fill_profinit}
\alias{scale_fill_profinit}
\alias{scale_fill_profinit_d}
\alias{scale_fill_profinit_c}
\title{Fill scale constructor for Profinit colors.}
\usage{
scale_fill_profinit(
  palette = "blue-red",
  discrete = TRUE,
  reverse = FALSE,
  exact = NULL,
  ...
)

scale_fill_profinit_d(palette = "blue-red", ...)

scale_fill_profinit_c(palette = "blue-red", ...)
}
\arguments{
\item{palette}{Character name of palette in \code{profinit_palettes}}

\item{discrete}{Boolean, indicating whether color aesthetic is discrete or not}

\item{reverse}{Boolean, indicating whether the palette should be reversed}

\item{exact}{Indicates whether the color scale is supposed to be followed exactly.
Be ware, you may run out of colors. Defaults to \code{TRUE} for discrete palette names, \code{FALSE} otherwise.}

\item{...}{Additional arguments passed to \code{discrete_scale()} or
\code{scale_fill_gradientn()}, used respectively when discrete is \code{TRUE} or \code{FALSE}}
}
\value{
Ggplot2 fill scale constructor based on Profinit color palette.
}
\description{
Fill scale constructor for Profinit colors.

\code{scale_fill_profinit_d} - Discrete Profinit fill scale (similar to
\code{scale_fill_viridis_d}). It can't be used with continuous variables.

\code{scale_fill_profinit_c} - Continuous Profinit fill scale (similar to
\code{scale_fill_viridis_c}). It can't be used with discrete variables.
}
\examples{
library(ggplot2)
plt <- ggplot(ggplot2::diamonds, ggplot2::aes(x = clarity, y = price, fill = clarity)) +
  geom_boxplot() +
  theme_profinit()

plt + scale_fill_profinit()

# Discrete scale, follow exact color codes (default for the `discrete` palette).
# ! You may run out of colors - see the example below.
# Use either exact = FALSE (next example) or `discrete-full` palette.
plt + scale_fill_profinit("discrete")

# Now, the colors are approximated
plt + scale_fill_profinit("discrete", exact = FALSE)

}
\concept{scale_fill_profinit}
