% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineit.R
\name{splineit}
\alias{splineit}
\title{splineit}
\usage{
splineit(var, min, max)
}
\arguments{
\item{var}{Continuous vector to spline.}

\item{min}{Min of spline.}

\item{max}{Max of spline.}
}
\value{
Splined Column
}
\description{
Splines a continuous variable
}
\examples{
library(dplyr)
library(prettyglm)
data('titanic')

columns_to_factor <- c('Pclass',
                      'Sex',
                      'Cabin',
                      'Embarked',
                      'Cabintype',
                      'Survived')
meanage <- base::mean(titanic$Age, na.rm=TRUE)

titanic  <- titanic  \%>\%
 dplyr::mutate_at(columns_to_factor, list(~factor(.))) \%>\%
 dplyr::mutate(Age =base::ifelse(is.na(Age)==TRUE,meanage,Age)) \%>\%
 dplyr::mutate(Age_0_25 = prettyglm::splineit(Age,0,25),
               Age_25_50 = prettyglm::splineit(Age,25,50),
               Age_50_120 = prettyglm::splineit(Age,50,120)) \%>\%
 dplyr::mutate(Fare_0_250 = prettyglm::splineit(Fare,0,250),
               Fare_250_600 = prettyglm::splineit(Fare,250,600))

}
