% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rexp_rs.R
\name{rexp_rs}
\alias{rexp_rs}
\title{Random Variable From an Exponential Distribution}
\usage{
rexp_rs(n = 10, rate = 1, pmean = 0, psd = 1, rev = FALSE)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{rate}{\code{rate} for \code{\link[stats:Exponential]{stats::rexp()}}.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}

\item{rev}{If TRUE, the distribution
is revered to generate a negatively
skewed distribution. Default is
FALSE.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from an exponential distribution,
rescaled to have user-specified
population mean and standard
deviation.
}
\details{
First, specify the parameter,
\code{rate}, and the
desired population mean and standard
deviation. The random numbers, drawn
from an exponential distribution by
\code{\link[stats:Exponential]{stats::rexp()}}, will then be
rescaled with the desired population
mean and standard.
}
\examples{
set.seed(90870962)
x <- rexp_rs(n = 5000,
             rate = 4,
             pmean = 3,
             psd = 1)
mean(x)
sd(x)
hist(x)

}
