% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_curve.R
\name{power_curve}
\alias{power_curve}
\alias{print.power_curve}
\title{Power Curve}
\usage{
power_curve(
  object,
  formula = NULL,
  start = NULL,
  lower_bound = NULL,
  upper_bound = NULL,
  nls_args = list(),
  nls_control = list(),
  verbose = FALSE,
  models = c("nls", "logistic", "lm")
)

\method{print}{power_curve}(x, data_used = FALSE, digits = 3, right = FALSE, row.names = FALSE, ...)
}
\arguments{
\item{object}{An object of the class
\code{power4test_by_n} or \code{power4test_by_es},
which is the output of \code{\link[=power4test_by_n]{power4test_by_n()}}
or \code{\link[=power4test_by_es]{power4test_by_es()}}.}

\item{formula}{A formula of the model
for \code{\link[stats:nls]{stats::nls()}}. It can also be
a list of formulas, and the models
will be fitted successively by
\code{\link[stats:nls]{stats::nls()}}, with the first
model fitted successfully adopted.
The response variable in the formula must be named
\code{reject}, and the predictor named
\code{x}. Whether \code{x} represents \code{n} or
\code{es} depends on the class of \code{object}.
If \code{NULL}, the default, it will be
determined internally based on the type of
\code{object}.}

\item{start}{Either a named vector
of the start value(s) of parameter(s)
in \code{formula}, or a list of named
vectors of the starting value(s)
of the list of formula(s). If \code{NULL},
the default, they will be determined
internally.}

\item{lower_bound}{Either a named vector
of the lower bound(s) of parameter(s)
in \code{formula}, or a list of named
vectors of the lower bound(s)
for the list of formula(s). They will
be passed to \code{lower} of \code{\link[stats:nls]{stats::nls()}}.
If \code{NULL}, the default, it will be
determined internally based on the type of
\code{object}.}

\item{upper_bound}{Either a named vector
of the upper bound(s) of parameter(s)
in \code{formula}, or a list of named
vectors of the upper bound(s)
for the list of formula(s). They will
be passed to \code{upper} of \code{\link[stats:nls]{stats::nls()}}.
If \code{NULL}, the default, it will be
determined internally based on the type of
\code{object}.}

\item{nls_args}{A named list of
arguments to be used when calling
\code{\link[stats:nls]{stats::nls()}}. Used to override
internal default, such as the
algorithm (default is \code{"port"}).
Use this argument with cautions.}

\item{nls_control}{A named list of
arguments to be passed the \code{control}
argument of \code{\link[stats:nls]{stats::nls()}}. The values will
override internal default values,
and also override \code{nls_args}.
Use this argument with cautions.}

\item{verbose}{Logical. Whether
messages will be printed when
trying different models.}

\item{models}{Models to try. Support
\code{"nls"} (fitted by \code{\link[=nls]{nls()}}),
\code{"logistic"} (fitted by \code{\link[=glm]{glm()}}), and
\code{"lm"} (fitted by \code{\link[=lm]{lm()}}). By default,
all three models will be attempted,
in this order.}

\item{x}{A \code{power_curve} object.}

\item{data_used}{Logical. Whether
the rejection rates data frame
used to fit the model is printed.}

\item{digits, right, row.names}{Arguments of the same names used
by the \code{print} method of a
\code{data.frame} object. Used when \code{data_used}
is \code{TRUE} and the rejection rates
data frame is printed.}

\item{...}{For the \code{print} method of
\code{power_curve} objects, they are optional
arguments to be passed to
\code{\link[=print.data.frame]{print.data.frame()}} when printing
the rejection rates data frame.}
}
\value{
It returns a list which is a
\code{power_curve} object, with the
following elements:
\itemize{
\item \code{fit}: The model fitted, which is the
output of \code{\link[stats:nls]{stats::nls()}},
\code{\link[stats:glm]{stats::glm()}}, or \code{\link[stats:lm]{stats::lm()}}.
\item \code{reject_df}: The table of reject
rates and other characteristics,
which is generated by
\code{\link[=rejection_rates]{rejection_rates()}}.
\item \code{predictor}: The predictor or the
power curve, ether \code{"n"} (sample
size) or \code{"es"} (population effect
size).
\item \code{call}: The call used to run this
function.
}

The \code{print} method of \code{power_curve}
object returns \code{x} invisibly. Called
for its side-effect.
}
\description{
Estimate the relation
between power and a characteristic,
such as sample size or population
effect size (population value of
a model parameter).
}
\details{
The function \code{\link[=power_curve]{power_curve()}}
retrieves the information
from the output of
\code{\link[=power4test_by_n]{power4test_by_n()}} or
\code{\link[=power4test_by_es]{power4test_by_es()}}, and
estimate the power curve: the
relation between the characteristic
varied, sample size for
\code{\link[=power4test_by_n]{power4test_by_n()}} and the
population effect size for
\code{\link[=power4test_by_es]{power4test_by_es()}}, and the
rejection rate of the test conducted
by \code{\link[=power4test_by_n]{power4test_by_n()}} or
\code{\link[=power4test_by_es]{power4test_by_es()}}. This
rejection rate is the power when the
null hypothesis is false (e.g., the
population value of the effect size
being tested is nonzero).

The model fitted is \emph{not} intended to
be a precise model for the relation
across a wide range. It is only a
crude estimate based on the limited
number of values of the
characteristic (e.g., sample size)
examined, which can be as small as
four or even smaller. The model is
intended to be
used for only for the range covered,
and for estimating the probable
sample size or effect size with a
desirable level of power. This value
should then be studied by higher
precision through simulation
using functions such as
\code{\link[=power4test]{power4test()}}.

These are the models to be tried,
in the following order:
\itemize{
\item One or nonlinear models, to be
fitted by \code{\link[stats:nls]{stats::nls()}}. If
several models are specified, all
will be fitted and the one with the
smallest deviance will be used.
\item If all the nonlinear models failed,
for whatever reason, a logistic
regression will be fitted by
\code{\link[stats:glm]{stats::glm()}} to predict the
binary significant test results.
\item If the logistic model also failed,
for whatever reason, a simple
linear regression model will be
fitted. Although the power curve is
nonlinear across a wide range of,
say, sample size, a linear model
can still be a good enough
approximation for a narrow range of
the predictor.
}

The output can then be plotted to
visualize the power curve, using
the \code{plot} method (\code{\link[=plot.power_curve]{plot.power_curve()}})
for the output
of \code{\link[=power_curve]{power_curve()}}.

This function can be used directly,
but is also used internally by
functions such as \code{\link[=x_from_power]{x_from_power()}}.
}
\examples{

# Specify the population model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the effect sizes (population parameter values)

model_simple_med_es <-
"
y ~ m: l
m ~ x: m
y ~ x: s
"

# Simulate datasets to check the model
# Set `parallel` to TRUE for faster, usually much faster, analysis
# Set `progress` to TRUE to display the progress of the analysis

sim_only <- power4test(nrep = 10,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 50,
                       fit_model_args = list(fit_function = "lm"),
                       do_the_test = FALSE,
                       iseed = 1234,
                       parallel = FALSE,
                       progress = FALSE)

# By n: Do a test for different sample sizes

out1 <- power4test_by_n(sim_only,
                        nrep = 10,
                        test_fun = test_parameters,
                        test_args = list(par = "y~x"),
                        n = c(25, 50, 100),
                        by_seed = 1234,
                        parallel = FALSE,
                        progress = FALSE)

pout1 <- power_curve(out1)
pout1
plot(pout1)

# By pop_es: Do a test for different population values of a model parameter

out2 <- power4test_by_es(sim_only,
                         nrep = 10,
                         test_fun = test_parameters,
                         test_args = list(par = "y~x"),
                         pop_es_name = "y ~ x",
                         pop_es_values = c(0, .3, .5),
                         by_seed = 1234,
                         parallel = FALSE,
                         progress = FALSE)

pout2 <- power_curve(out2)
pout2
plot(pout2)

}
\seealso{
\code{\link[=power4test_by_n]{power4test_by_n()}} and \code{\link[=power4test_by_es]{power4test_by_es()}}
for the output supported by
\code{\link[=power_curve]{power_curve()}}, \code{\link[=plot.power_curve]{plot.power_curve()}}
for the \code{plot} method and
\code{\link[=predict.power_curve]{predict.power_curve()}}
for the \code{predict} method of the output
of \code{\link[=power_curve]{power_curve()}}.
}
