% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_regmatches_if_not_empty}
\alias{utils_regmatches_if_not_empty}
\title{Conditionally amend character string vector.}
\usage{
utils_regmatches_if_not_empty(
  string_filter,
  string_search,
  regex_search,
  ignore_case_search
)
}
\arguments{
\item{string_filter}{A Character string vector.}

\item{string_search}{Alternative character string to search into for the
pattern provided in \code{regex_search} below}

\item{regex_search}{Alternative pattern provided as a character string regex
to look for in the alternative character string provided in \code{string_search}
above.}

\item{ignore_case_search}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) in search for \code{regex_search} in \code{string_search}.}
}
\value{
A list of character string vectors.
}
\description{
Searches for non-empty string in provided character string vector. If found
searches for alternative pattern in an alternative character string and
returns any match or an empty string if none.
}
\examples{
\dontrun{
  utils_regmatches_if_not_empty(
    c("glasgow-entrepreneurs", "", "aberdeen-entrepreneurs"),
    "edinburgh-entrepreneurs" , "^edinburgh", TRUE
  )
}
}
