% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.glm.R
\name{pmml.glm}
\alias{pmml.glm}
\title{Generate the PMML representation for a glm object from the package \pkg{stats}.}
\usage{
\method{pmml}{glm}(
  model,
  model_name = "General_Regression_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Generalized Linear Regression Model",
  copyright = NULL,
  model_version = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{model}{A glm object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{model_version}{A string specifying the model version.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{weights}{The weights used for building the model.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the glm object.
}
\description{
Generate the PMML representation for a glm object from the package \pkg{stats}.
}
\details{
The function exports the glm model in the PMML GeneralRegressionModel
format.

Note on glm models for 2-class problems: a dataset where the target
categorical variable has more than 2 classes may be turned into a 2-class
problem by creating a new target variable that is TRUE for a particular
class and FALSE for all other classes. While the R formula function allows
such a transformation to be passed directly to it, this may cause issues
when the model is converted to PMML. Therefore, it is advised to create a
new 2-class separately, and then pass that variable to glm(). This is shown
in an example below.
}
\examples{
\dontrun{
data(iris)
mod <- glm(Sepal.Length ~ ., data = iris, family = "gaussian")
mod_pmml <- pmml(mod)
rm(mod, mod_pmml)

data(audit)
mod <- glm(Adjusted ~ Age + Employment + Education + Income, data = audit, family = binomial(logit))
mod_pmml <- pmml(mod)
rm(mod, mod_pmml)

# Create a new 2-class target from a 3-class variable:
data(iris)
dat <- iris[, 1:4]
# Add a new 2-class target "Species_setosa" before passing it to glm():
dat$Species_setosa <- iris$Species == "setosa"
mod <- glm(Species_setosa ~ ., data = dat, family = binomial(logit))
mod_pmml <- pmml(mod)
rm(dat, mod, mod_pmml)
}
}
\references{
\href{http://stat.ethz.ch/R-manual/R-devel/library/stats/html/glm.html}{R project: Fitting Generalized Linear Models}
}
