#' @title Specmeters broadband sensors
#'
#' @description A vector of indexes for extracting subsets of spectra from the
#' \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of names of members of the collection of spectra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#'
#' Specmeters 3415F PAR quantum sensor
#'
#' @note
#' Digitized with 'DigitizeIt' from manufacturers product Quantum Light Meters
#' PRODUCT MANUAL (R 06/14). This are approximate data, both because of the
#' digitizing process, and because they are either typical values or for a
#' specific sensor unit. Individual sensor units are expected to differ to some
#' degree in spectral response.
#'
#' Manufacturer: Spectrum Technologies, Inc., Aurora, IL, USA.
#'
#' @references Quantum Light Meters PRODUCT MANUAL (R 06/14).
#' \url{https://www.specmeters.com/}
#'
#' @examples
#'
#' specmeters_sensors
#'
"specmeters_sensors"
