% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.var.r
\name{s_var}
\alias{s_var}
\alias{s_var.default}
\alias{s_var.generic_spct}
\alias{s_var.filter_mspct}
\alias{s_var.source_mspct}
\alias{s_var.response_mspct}
\alias{s_var.reflector_mspct}
\alias{s_var.calibration_mspct}
\alias{s_var.cps_mspct}
\alias{s_var.raw_mspct}
\title{Variance of a collection of spectra}
\usage{
s_var(x, na.rm, ...)

\method{s_var}{default}(x, na.rm = FALSE, ...)

\method{s_var}{generic_spct}(x, na.rm = FALSE, ...)

\method{s_var}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object belongs to the same class
  as the members of the collection, such as \code{"filter_spct"}, containing
  the summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" variance of values across members of a
collections of spectra or of a spectral object containing multiple spectra in
long form.
}
\details{
Method specializations compute the variance at each wavelength
  across a group of spectra stored in an object of one of the classes defined
  in package 'photobiology'. Omission of NAs is done separately at each
  wavelength. Interpolation is not applied, so all spectra in \code{x} must
  share the same set of wavelengths. An error is triggered if this condition
  is nor fulfilled.
}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The parallel
  summaries' methods accept as arguments objects of these classes only if
  spectra contain data for a single spectrometer scan. In the case of
  \code{cps_spct} objects, a single column can also contain data from
  multiple scans spliced into a single variable.
}
\examples{
s_var(sun_evening.mspct)

}
\seealso{
See \code{\link[stats]{cor}} for details about \code{var()},
  which is used for the computations.
}
