% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getInstrDesc}
\alias{getInstrDesc}
\alias{instr_descriptor}
\title{Get the "instr.desc" attribute}
\usage{
getInstrDesc(x)

instr_descriptor(x)
}
\arguments{
\item{x}{a \code{generic_spct} object or a \code{summary_generic_spct}
object.}
}
\value{
an object of class \code{"instr_desc"} derived from \code{"list"}.
  The fields \code{spectrometer.name}, \code{spectrometer.sn},
  \code{bench.grating} and \code{bench.slit} are always present, although may
  be set to \code{NA}. Additional fields can be present depending on the
  origin of the data.
}
\description{
Function to query the \code{"instr.desc"} attribute of an existing
\code{generic_spct} or derived-class object, or of a
\code{summary_generic_spct} or derived-class object.
}
\examples{
valid.descriptor <- getInstrDesc(white_led.cps_spct)
class(valid.descriptor)
print(valid.descriptor)
print(str(valid.descriptor))

missing.descriptor <- getInstrDesc(white_body.spct)
class(missing.descriptor)
print(missing.descriptor)
print(str(missing.descriptor))

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
