% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distMatrix}
\alias{distMatrix}
\title{Calculate a Distance Matrix}
\usage{
distMatrix(M, fn = "textDist", ...)
}
\arguments{
\item{M}{A numeric matrix}

\item{fn}{The name of a distance function, default is "textDist".}

\item{...}{Additional arguments to be passed to the distance function}
}
\value{
The distance matrix with the distance between all combinations
of the columns of \code{M} according to the distance function in \code{fn}.
}
\description{
Calculate a distance matrix for a numeric matrix, where a distance function
is used to calculate the distance between all combinations of the columns
of the matrix \code{M}.
}
\examples{
M=matrix(c(0,1,0,2,0,10,0,14,12,0,8,0,1,0,1,0),4)
colnames(M)=1:4;rownames(M)=c("A","B","C","D")
M
#Text distance matrix
distMatrix(M)
#Canberra distance matrix
distMatrix(M,"canberra")
}
