% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFSource.R
\name{DFSource}
\alias{DFSource}
\title{Create a DFSource object from a data frame}
\usage{
DFSource(x)
}
\arguments{
\item{x}{A dataframe with at a minimum a text and id column,
and a row for each document to be stored in a corpus.}
}
\value{
A DFSource object containing the encoding set to "", the number
of rows (length), the current position (position=0), the type of
reader to use (reader=readDF), and the content (\code{x}).
}
\description{
This function will create a DFSource object from a data frame that contains
at least columns id and text, but may contain several more. VCorpus will
use this to read in each row from the data frame into a PlainTextDocument,
storing additional variables in its metadata. It will then combine all those 
PlainTextDocuments in a VCorpus object.
}
\examples{
(df=data.frame(id=1:3,text=c("First text","Second text","Third text"),
               title=c("N1","N2","N3")))
DFSource(df)
}
