% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals_api.R
\name{get_common_names_peru}
\alias{get_common_names_peru}
\title{Get taxonomic and common name information for Peru mammals}
\usage{
get_common_names_peru(splist, return_details = FALSE)
}
\arguments{
\item{splist}{Character vector of species names}

\item{return_details}{Logical. If TRUE, includes full taxonomic information
(default: FALSE)}
}
\value{
If return_details = FALSE: Character vector with common names
If return_details = TRUE: Tibble with taxonomic and common name information
}
\description{
Returns taxonomic classification and common names for species validated
against the Peru mammals database.
}
\examples{

species <- c("Panthera onca", "Tremarctos ornatus",
             "Puma concolor", "Myotis bakeri")

# Get common names
# Vector
get_common_names_peru(species)
# tibble
tibble::tibble(splist = species) |>
 dplyr::mutate(endemic = get_common_names_peru(splist))

# Get full taxonomic information
taxonomy <- get_common_names_peru(species, return_details = TRUE)
taxonomy


}
