% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_mse.R
\name{performance_mse}
\alias{performance_mse}
\alias{mse}
\title{Mean Square Error of Linear Models}
\usage{
performance_mse(model, ...)

mse(model, ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed down to \code{lme4::bootMer()} or \code{boot::boot()}
for bootstrapped ICC, R2, RMSE etc.; for \code{variance_decomposition()},
arguments are passed down to \code{brms::posterior_predict()}.}
}
\value{
Numeric, the mean square error of \code{model}.
}
\description{
Compute mean square error of linear models.
}
\details{
The mean square error is the mean of the sum of squared residuals, i.e. it
measures the average of the squares of the errors. Less technically speaking,
the mean square error can be considered as the variance of the residuals,
i.e. the variation in the outcome the model doesn't explain. Lower values
(closer to zero) indicate better fit.
}
\examples{
data(mtcars)
m <- lm(mpg ~ hp + gear, data = mtcars)
performance_mse(m)
}
