% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock_financials.R
\name{md_stock_financials}
\alias{md_stock_financials}
\title{query financial statements}
\usage{
md_stock_financials(type = NULL, date_range = "1q", from = NULL,
  to = Sys.Date(), print_step = 1L, ...)
}
\arguments{
\item{type}{the type of financial statements.}

\item{date_range}{date range. Available value including '1m'-'11m', 'ytd', 'max' and '1y'-. Default is '3y'.}

\item{from}{the start date. Default is NULL.}

\item{to}{the end date. Default is current system date.}

\item{print_step}{A non-negative integer. Print financial statements name by each print_step iteration. Default is 1L.}

\item{...}{Additional parameters.}
}
\description{
\code{md_stock_financials} provides an interface to query financial statements for all listed companies in SSE and SZSE by specified report date.
}
\examples{
\dontrun{
# interactively specify type of financial table 
dtfs1 = md_stock_financials(type="fs0_summary", to = '2022-12-31')
dtfs2 = md_stock_financials(type="fs0_summary", to = c('2022-12-31', '2023-03-31'))
dtfs3 = md_stock_financials(type="fs0_summary", from = '2022-12-31', to = Sys.Date())

# all statements
dtfs4 = md_stock_financials(type = "fs", to = '2022-12-31')

# setting column names to Chinese
dtfs5 = md_stock_financials(type="fs0_summary", to = '2022-12-31', colnam_chn = TRUE)

}

}
