% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{plot.pc_matrix}
\alias{plot.pc_matrix}
\title{Plot Pattern Causality Matrix}
\usage{
\method{plot}{pc_matrix}(
  x,
  status,
  width = 0.85,
  height = 0.75,
  radius = grid::unit(3, "pt"),
  alpha = 0.53,
  show_text = FALSE,
  show_legend_title = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{pc_matrix} object containing causality matrices.}

\item{status}{The type of causality to plot ("positive", "negative", or "dark").}

\item{width}{Numeric value specifying the width of the bars (default: 0.85).}

\item{height}{Numeric value specifying the height of the bars (default: 0.75).}

\item{radius}{Grid unit specifying the corner radius of the bars.}

\item{alpha}{Numeric value specifying the transparency (default: 0.53).}

\item{show_text}{Logical, whether to show numerical values on the plot.}

\item{show_legend_title}{Logical, whether to display the legend title.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
A ggplot object invisibly.
}
\description{
Creates a heatmap visualization of the pattern causality matrix for positive,
negative, or dark causality relationships.
This function generates a heatmap using \code{ggplot2} to visualize the specified
causality matrix.
}
\examples{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
plot(pc_matrix_obj, status = "positive")
}
\references{
Stavroglou et al. (2020) \doi{10.1073/pnas.1918269117}
}
