% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfaces.R
\name{stateSpaceMethod}
\alias{stateSpaceMethod}
\alias{stateSpaceMethod.default}
\alias{stateSpaceMethod.custom}
\title{State Space Reconstruction Interface}
\usage{
stateSpaceMethod(x, E, tau, ...)

\method{stateSpaceMethod}{default}(x, E, tau, ...)

\method{stateSpaceMethod}{custom}(x, E, tau, method, ...)
}
\arguments{
\item{x}{Input time series}

\item{E}{Embedding dimension (positive integer)}

\item{tau}{Time delay (positive integer)}

\item{...}{Additional arguments passed to methods}

\item{method}{Custom function for state space reconstruction}
}
\value{
A list containing the reconstructed state space components
}
\description{
A generic interface for reconstructing state spaces from time series
data using either built-in or custom methods.
}
\details{
Generic Interface for State Space Reconstruction
}
\section{Methods (by class)}{
\itemize{
\item \code{stateSpaceMethod(default)}: Default state space reconstruction

\item \code{stateSpaceMethod(custom)}: Custom state space reconstruction

}}
\examples{
\dontrun{
# Using default method
x <- rnorm(100)
s1 <- stateSpaceMethod(x, E=3, tau=2)

# Using custom method
custom_space <- function(x, E, tau) {
  list(matrix=embed(x, E))
}
s2 <- stateSpaceMethod(x, E=3, tau=2, method=custom_space)
}
}
