% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particule.R
\name{Particle}
\alias{Particle}
\title{Particle}
\description{
Class for the Particles used in the Particle Swarm Optimisation, It is call by the Particle Swarm object to make the population.
}
\examples{
# If you use the Particle Swarm Object there is no need to manually create the Particle
# But if you want to use the Particle for another project:

# In this example we use the PSO to solve the following equation:
# a * 5 + b * 25 + 10 = 15

fitness_function <- function(values){
  a <- values[1]
  b <- values[2]
  particule_result <- a*5 + b*25 + 10
  difference <- 15 - particule_result
  fitness <- 1 - abs(difference)
  return(fitness)
}

values_ranges <- list(c(-10^3,10^3),c(-10^3,10^3))

particle_example <- Particle$new(values_ranges = values_ranges,
                                 values = c(0,0),
                                 fitness_function = fitness_function,
                                 acceleration_coefficient = c(0.5,0.5),
                                 inertia = 0.4)
print(particle_example)
particle_example$get_fitness()
print(particle_example)
particle_example$update(c(10,25))
print(particle_example)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{values_ranges}}{(list) max and min for each value of the particle}

\item{\code{values}}{(numeric) values of the particle (his position in space)}

\item{\code{fitness}}{(numeric) fitness of the particle (his score)}

\item{\code{fitness_function}}{(function) function used to find the fitness}

\item{\code{personal_best_values}}{(numeric) Best values of the particle}

\item{\code{personal_best_fitness}}{(numeric) Fitness of the best values}

\item{\code{velocity}}{(numeric) Velocity of the particle (one velocity for each values)}

\item{\code{acceleration_coefficient}}{(numeric) coefficient c1 and c2 (for personal and global best)}

\item{\code{inertia}}{(numeric) inertia of the particle}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Particle$new()}}
\item \href{#method-get_fitness}{\code{Particle$get_fitness()}}
\item \href{#method-update}{\code{Particle$update()}}
\item \href{#method-update_personal_best_fitness}{\code{Particle$update_personal_best_fitness()}}
\item \href{#method-print}{\code{Particle$print()}}
\item \href{#method-clone}{\code{Particle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Particle object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$new(
  values_ranges,
  values,
  fitness_function,
  acceleration_coefficient,
  inertia
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values_ranges}}{range for each value of the particle (min and max), his size need to be the same as values. (List)}

\item{\code{values, }}{values of the particles. (numeric)}

\item{\code{fitness_function}}{function used to test the Particle and find his fitness. (function)}

\item{\code{acceleration_coefficient}}{a vector of two values, one for c1 (the personal coefficient), and one for c2 (the global coefficient). (numeric)}

\item{\code{inertia}}{The inertia of the particle (the influence of the previous velocity on the next velocity). (numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Particle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_fitness"></a>}}
\if{latex}{\out{\hypertarget{method-get_fitness}{}}}
\subsection{Method \code{get_fitness()}}{
Calculate the fitness of the particle with the fitness function and save it in self$fitness
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$get_fitness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\if{latex}{\out{\hypertarget{method-update}{}}}
\subsection{Method \code{update()}}{
Update Particle's position and velocity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$update(swarm_best)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{swarm_best}}{the best values of the swarm used to update the velocity}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_personal_best_fitness"></a>}}
\if{latex}{\out{\hypertarget{method-update_personal_best_fitness}{}}}
\subsection{Method \code{update_personal_best_fitness()}}{
Update the Particle's best values and fitness.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$update_personal_best_fitness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print the current values of the particle and his fitness
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Particle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
