% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract-parsnip}
\alias{extract-parsnip}
\alias{extract_spec_parsnip.model_fit}
\alias{extract_fit_engine.model_fit}
\alias{extract_parameter_set_dials.model_spec}
\alias{extract_parameter_dials.model_spec}
\alias{extract_fit_time.model_fit}
\title{Extract elements of a parsnip model object}
\usage{
\method{extract_spec_parsnip}{model_fit}(x, ...)

\method{extract_fit_engine}{model_fit}(x, ...)

\method{extract_parameter_set_dials}{model_spec}(x, ...)

\method{extract_parameter_dials}{model_spec}(x, parameter, ...)

\method{extract_fit_time}{model_fit}(x, summarize = TRUE, ...)
}
\arguments{
\item{x}{A parsnip \code{model_fit} object or a parsnip \code{model_spec} object.}

\item{...}{Not currently used.}

\item{parameter}{A single string for the parameter ID.}

\item{summarize}{A logical for whether the elapsed fit time should be
returned as a single row or multiple rows. Doesn't support \code{FALSE} for
parsnip models.}
}
\value{
The extracted value from the parsnip object, \code{x}, as described in the description
section.
}
\description{
These functions extract various elements from a parsnip object. If they do
not exist yet, an error is thrown.
\itemize{
\item \code{extract_spec_parsnip()} returns the parsnip \link[=model_spec]{model specification}.
\item \code{extract_fit_engine()} returns the engine specific fit embedded within
a parsnip model fit. For example, when using \code{\link[=linear_reg]{linear_reg()}}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{extract_parameter_dials()} returns a single dials parameter object.
\item \code{extract_parameter_set_dials()} returns a set of dials parameter objects.
\item \code{extract_fit_time()} returns a tibble with fit times. The fit times
correspond to the time for the parsnip engine to fit and do not include
other portions of the elapsed time in \code{\link[=fit.model_spec]{fit.model_spec()}}.
}
}
\details{
Extracting the underlying engine fit can be helpful for describing the
model (via \code{print()}, \code{summary()}, \code{plot()}, etc.) or for variable
importance/explainers.

However, users should not invoke the \code{predict()} method on an extracted
model. There may be preprocessing operations that parsnip has executed on
the data prior to giving it to the model. Bypassing these can lead to errors
or silently generating incorrect predictions.

\strong{Good}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{   parsnip_fit |> predict(new_data)
}\if{html}{\out{</div>}}

\strong{Bad}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{   parsnip_fit |> extract_fit_engine() |> predict(new_data)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("dials")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lm_spec <- linear_reg() |> set_engine("lm")
lm_fit <- fit(lm_spec, mpg ~ ., data = mtcars)

lm_spec
extract_spec_parsnip(lm_fit)

extract_fit_engine(lm_fit)
lm(mpg ~ ., data = mtcars)
\dontshow{\}) # examplesIf}
}
