% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{\%ret\%}
\alias{\%ret\%}
\title{Return a fixed value instead of the result of a parser}
\usage{
p \%ret\% c
}
\arguments{
\item{p}{a parser.}

\item{c}{string, \emph{i.e.} a single-element character vector. \code{NULL} is coerced
to \code{character(0)}.}
}
\value{
A parser.
}
\description{
Sometimes we are not interested in the result from a parser, only that the
parser succeeds. It may be convenient to return some short representation
or nothing even rather than the string itself. The \verb{\%ret\%} combinator is
useful in such cases. The parser \code{(p \%ret\% c)} has the same behavior as \code{p},
except that it returns the value \code{c} if successful.
}
\section{Pseudocode}{


\preformatted{
(p \%xret\% c)(x):
  if p(x)==[] then fail()(x)
  else succeed(c)(x[-1])
}
}

\examples{
(literal("A") \%ret\% "We have an A!")(LETTERS[1:5])
(literal("A") \%ret\% NULL)(LETTERS[1:5])
}
\seealso{
\link{\%using\%}
}
