% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{parameters-options}
\alias{parameters-options}
\title{Global options from the parameters package}
\description{
Global options from the parameters package
}
\section{Global options to set defaults for function arguments}{


The \code{verbose} argument can be used to display or silence messages and
warnings for the different functions in the \strong{parameters} package. However,
some messages providing additional information can be displayed or suppressed
using \code{options()}:
\itemize{
\item \code{options(parameters_info = TRUE)} will override the \code{include_info} argument
in \code{model_parameters()} and always show the model summary for non-mixed
models.
\item \code{options(parameters_mixed_info = TRUE)} will override the \code{include_info}
argument in \code{model_parameters()} for mixed models, and will then always
show the model summary.
\item \code{options(parameters_cimethod = TRUE)} will show the additional information
about the approximation method used to calculate confidence intervals and
p-values. Set to \code{FALSE} to hide this message when printing
\code{model_parameters()} objects.
\item \code{options(parameters_exponentiate = TRUE)} will show the additional
information on how to interpret coefficients of models with log-transformed
response variables or with log-/logit-links when the \code{exponentiate}
argument in \code{model_parameters()} is not \code{TRUE}. Set this option to \code{FALSE}
to hide this message when printing \code{model_parameters()} objects.
}

There are further options that can be used to modify the default behaviour
for printed outputs:
\itemize{
\item \code{options(parameters_labels = TRUE)} will use variable and value labels for
pretty names, if data is labelled. If no labels available, default pretty
names are used.
\item \verb{options(parameters_interaction = <character>)} will replace the
interaction mark (by default, \code{*}) with the related character.
\item \verb{options(parameters_select = <value>)} will set the default for the
\code{select} argument. See argument's documentation for available options.
\item \verb{options(easystats_table_width = <value>)} will set the default width for
tables in text-format, i.e. for most of the outputs printed to console. If
not specified, tables will be adjusted to the current available width, e.g.
of the of the console (or any other source for textual output, like
markdown files). The argument \code{table_width} can also be used in most
\code{print()} methods to specify the table width as desired.
\item \code{options(insight_use_symbols = TRUE)} will try to print unicode-chars for
symbols as column names, wherever possible (e.g.,
\ifelse{html}{\out{&omega;}}{\eqn{\omega}} instead of \code{Omega}).
\item \verb{options(easystats_display_format = <value>)} will set the default format for
the \code{display()} methods. Can be one of \code{"markdown"}, \code{"html"}, or \code{"tt"}.
See \code{\link[=display.parameters_model]{display.parameters_model()}} for details.
}
}

