% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute_df_into_label.R
\name{transmute_df_into_label}
\alias{transmute_df_into_label}
\alias{df_into_label}
\alias{transmute_df_into_label.apa_results}
\alias{transmute_df_into_label.apa_results_table}
\title{Transmute Degrees-of-Freedom Columns into Variable Labels}
\usage{
transmute_df_into_label(x, check_df = TRUE, ...)

df_into_label(x, check_df = TRUE, ...)

\method{transmute_df_into_label}{apa_results}(x, check_df = TRUE, ...)

\method{transmute_df_into_label}{apa_results_table}(x, check_df = TRUE, ...)
}
\arguments{
\item{x}{Either the complete output object created by \code{\link[=apa_print]{apa_print()}} methods,
or the \code{table} component of such objects.}

\item{check_df}{Logical. If TRUE (the default), checks if degrees-of-freedom-columns contain non-integer values.}

\item{...}{further arguments passed from an to other methods}
}
\value{
An object of the same class as \code{x}, where a redundant column with
degrees of freedom has been incorporated into the column label of the column
\code{statistic}.
}
\description{
Takes the output from \code{\link[=apa_print]{apa_print()}} methods and modifies the results table
by transmuting information about degrees of freedom into the variable labels of
test-statistic columns.
}
\examples{
  apa_out <- apa_print(aov(yield ~ N * P, npk))

  # Standard output with separate columns for degrees of freedom:
  apa_out$table

  # Modified output where degrees of freedom are incorporated into the variable
  # label of column 'statistic':
  transmute_df_into_label(apa_out)$table


}
