% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_anova.R
\name{print_anova}
\alias{print_anova}
\title{Format statistics from ANOVA (APA 6th edition)}
\usage{
print_anova(
  x,
  intercept = FALSE,
  observed = NULL,
  es = "ges",
  mse = getOption("papaja.mse"),
  in_paren = FALSE
)
}
\arguments{
\item{x}{Data.frame. A \code{data.frame} of class \code{apa_variance_table} as returned by \code{\link{arrange_anova}}.}

\item{intercept}{Logical. Indicates if intercept test should be included in output.}

\item{observed}{Character. The names of the factors that are observed, (i.e., not manipulated). Necessary for calculation of generalized eta-squared; otherwise ignored.}

\item{es}{Character. The effect-size measure to be calculated; can be either \code{ges} for generalized eta-squared, \code{pes} for partial eta-squared or \code{es} for eta-squared.
Note that eta-squared is calculated correctly if and only if the design is balanced.}

\item{mse}{Logical. Indicates if mean squared errors should be included in output. Default is \code{TRUE}.}

\item{in_paren}{Logical. Indicates if the formatted string will be reported inside parentheses. See details.}
}
\value{
A named list containing the following components:

\describe{
\item{\code{statistic}}{A named list of character strings giving the test statistic, parameters, and \emph{p}
value for each factor.}
\item{\code{estimate}}{A named list of character strings giving the effect size estimates for each factor.} \% , either in units of the analyzed scale or as standardized effect size.
\item{\code{full_result}}{A named list of character strings comprised of \code{estimate} and \code{statistic} for each factor.}
\item{\code{table}}{A data.frame containing the complete ANOVA table, which can be passed to \code{\link{apa_table}}.}
}
}
\description{
This function is the former internal workhorse of the \code{apa_print}-family for ANOVA. It takes a \code{data.frame}
of class \code{apa_variance_table} and produces strings to report the results in accordance with APA manuscript
guidelines. It is already deprecated and will soon be defunct. \emph{This function is not exported.}
}
\seealso{
\code{\link[=arrange_anova]{arrange_anova()}}, \code{\link[=apa_print.aov]{apa_print.aov()}}
}
\keyword{internal}
