% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_profiles}
\alias{oadmin.user_profiles}
\title{Get user profiles}
\usage{
oadmin.user_profiles(opal, df = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
When a user has logged in Opal, he/she has a profile representing its activity. The user
can be defined in the Opal internal user registry, or in an external realm.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
oadmin.user_profiles(o)
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_add}()},
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
