% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filterAdditional}
\alias{filterAdditional}
\title{Filter the additional_name-additional_level pair in a summarised_result}
\usage{
filterAdditional(result, ...)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{...}{Expressions that return a logical value (\code{additionalColumns()} are
used to evaluate the expression), and are defined in terms of the variables
in .data. If multiple expressions are included, they are combined with the &
operator. Only rows for which all conditions evaluate to TRUE are kept.}
}
\value{
A \verb{<summarised_result>} object with only the rows that fulfill the
required specified additional.
}
\description{
Filter the additional_name-additional_level pair in a summarised_result
}
\examples{
library(dplyr)
library(omopgenerics)

x <- tibble(
  "result_id" = 1L,
  "cdm_name" = "eunomia",
  "group_name" = "cohort_name",
  "group_level" = c("cohort1", "cohort2", "cohort3"),
  "strata_name" = "sex",
  "strata_level" = "Female",
  "variable_name" = "number subjects",
  "variable_level" = NA_character_,
  "estimate_name" = "count",
  "estimate_type" = "integer",
  "estimate_value" = c("100", "44", "14"),
  "additional_name" = c("year", "time_step", "year &&& time_step"),
  "additional_level" = c("2010", "4", "2015 &&& 5")
) |>
  newSummarisedResult()

x |>
  filterAdditional(year == "2010")

}
