% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceanis-package.R
\name{set_couleur_}
\alias{set_couleur_}
\alias{set_couleur_ronds}
\alias{set_couleur_classes}
\alias{set_couleur_typo}
\alias{set_couleur_joignantes}
\alias{set_couleur_saphirs}
\title{Modify the colors of 'leaflet' map's analysis}
\usage{
set_couleur_ronds(map, colorPos = "#EB617F", colorNeg = "#286AC7",
map_leaflet = NULL)

set_couleur_classes(map, stylePalette = "defaut", palettePos = NULL,
paletteNeg = NULL, colBorder = "white", map_leaflet = NULL)

set_couleur_typo(map, paletteTypo = NULL, colBorder = "white", map_leaflet =
NULL)

set_couleur_joignantes(map, colFleche = "#286AC7", colBorder = "black",
map_leaflet = NULL)

set_couleur_saphirs(map, colEntree = "#EB617F", colSortie = "#286AC7",
colBorder = "black", map_leaflet = NULL)
}
\arguments{
\item{map}{objet leaflet.}

\item{colorPos}{chaine de caracteres (character). Couleur nommee ou
hexadecimal. Par defaut "#EB617F".}

\item{colorNeg}{chaine de caracteres (character). Couleur nommee ou
hexadecimal. Par defaut "#286AC7".}

\item{stylePalette}{chaine de caracteres (character). A choisir parmi
"defaut", "Insee_Rouge", "Insee_Jaune", "Insee_Bleu", "Insee_Turquoise",
"Insee_Vert", "Insee_Violet" ou "Insee_Gris" (voir
'affiche_palette(nomPalette)').}

\item{palettePos}{vecteur de caracteres (character). Specifier le vecteur de
couleurs (nommees ou hexadecimal) des valeurs positives (au choix). Par
defaut a NULL.}

\item{paletteNeg}{vecteur de caracteres (character). Specifier le vecteur de
couleurs (nommees ou hexadecimal) des valeurs negatives (au choix). Par
defaut a NULL.}

\item{paletteTypo}{vecteur de caracteres (character). Specifier le vecteur
de couleurs (nommees ou hexadecimal) de la typologie (au choix). Par defaut
a NULL.}

\item{colBorder}{chaine de caracteres (character). Couleur nommee (par
exemple "white") ou hexadecimal (par exemple "#FFFFFF"). Par defaut "white"
pour classes et typo, "black" pour joignantes et saphirs.}

\item{colFleche}{chaine de caracteres (character). Couleur nommee ou
hexadecimal. Par defaut "#286AC7".}

\item{colEntree}{chaine de caracteres (character). Couleur nommee ou
hexadecimal. Par defaut "#EB617F".}

\item{colSortie}{chaine de caracteres (character). Couleur nommee ou
hexadecimal. Par defaut "#286AC7".}

\item{map_leaflet}{objet leaflet. Pour l'integration des fonctions leaflet
dans les applications shiny (cf vignette). Par defaut a NULL.}
}
\value{
Retourne un objet de type leaflet.
}
\description{
Modify the colors of 'leaflet' map's analysis.
}
\details{
Les palettes proposées pour l'analyse en classes sont celles
utilisées par la Charte Graphique INSEE. Utilisez la fonction
affiche_palette(nomPalette) pour visualiser les couleurs d'une palette.
L'argument 'nomPalette' peut prendre comme valeur : "defaut", "Insee_Rouge",
"Insee_Jaune", "Insee_Bleu", "Insee_Turquoise", "Insee_Vert", "Insee_Violet"
ou "Insee_Gris".

Le code des couleurs est le code hexadécimal. Pour récupérer les codes
hexadécimaux des différentes palettes proposées : data("palettes_insee")
}
\examples{

data("depm")

data("donnees_monoloc")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm, idData = "COD_DEP",
varVolume = "POP_2015")
map <- set_couleur_ronds(map = map, colorPos = "orange")
\donttest{
 map
}

# Ronds proportionnels sur une analyse en classes
map <- leaflet_classes_ronds(data = donnees_monoloc, fondMaille = depm, idData = "COD_DEP",
varVolume = "POP_2015", varRatio = "VAR_AN_MOY", nbClasses = 4)
map <- set_couleur_classes(map = map, stylePalette = "Insee_Rouge", colBorder = "black")
\donttest{
 map
}

data("donnees_biloc_saphirs")
data("regm")

# Fleches saphirs
map <- leaflet_saphirs(data = donnees_biloc_saphirs, fondMaille = regm, typeMaille = "REG",
idDataDepart = "REG_DEPART", idDataArrivee = "REG_ARRIVEE",
varFlux = "MIGR", largeurFlecheMax = 500, direction = "Ent")
map <- set_couleur_saphirs(map = map, colEntree = "#4BB375", colBorder = "grey")
\donttest{
 map
}

}
\references{
Un convertisseur de couleurs pour visualiser une couleur a
partir de son nom, son code hexadecimal ou RGB :
http://www.proftnj.com/RGB3.htm
}
\seealso{
\code{\link{recup_palette},}

\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes}, \link{leaflet_classes_ronds},
\link{leaflet_typo},}

\code{\link{leaflet_oursins}, \link{leaflet_joignantes},
\link{leaflet_saphirs}}
}
\keyword{documentation}
