% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_dop_juvenile_rearrest_rate.R
\name{nyc_dop_juvenile_rearrest_rate}
\alias{nyc_dop_juvenile_rearrest_rate}
\title{NYC DOP Juvenile Rearrest Rate (Monthly Average)}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/c87b-2j3i>
}
\usage{
nyc_dop_juvenile_rearrest_rate(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing NYC DOP Juvenile Rearrest Rate (Monthly Average) data.
}
\description{
Downloads DOP Juvenile Rearrest Rate (Monthly Average) data from NYC Open Data.
}
\details{
This dataset provides the average monthly rate of juvenile rearrests
reported by the NYC Department of Probation (DOP). Data includes region,
year, and monthly averages, allowing for trend analysis across boroughs.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 10 rows)
  small_sample <- nyc_dop_juvenile_rearrest_rate(limit = 10)
  head(small_sample)

  nyc_dop_juvenile_rearrest_rate(limit = 5000)
  nyc_dop_juvenile_rearrest_rate(filters = list(borough = "Citywide"))
}
}
}
