% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_functions.R
\name{ci.cvAUC_withIC}
\alias{ci.cvAUC_withIC}
\title{ci.cvAUC_withIC}
\usage{
ci.cvAUC_withIC(
  predictions,
  labels,
  label.ordering = NULL,
  folds = NULL,
  confidence = 0.95
)
}
\arguments{
\item{predictions}{A vector, matrix, list, or data frame containing the predictions.}

\item{labels}{A vector, matrix, list, or data frame containing the true class labels. Must have the 
same dimensions as \code{predictions}.}

\item{label.ordering}{The default ordering of the classes can be changed by supplying 
a vector containing the negative and the positive class label (negative label first, 
positive label second).}

\item{folds}{If specified, this must be a vector of fold ids equal in length to \code{predictions} 
and \code{labels}, or a list of length V (for V-fold cross-validation) of vectors of indexes for 
the observations contained in each fold. The \code{folds} argument must only be specified if 
the \code{predictions} and \code{labels} arguments are vectors.}

\item{confidence}{number between 0 and 1 that represents confidence level.}
}
\value{
A list containing the following named elements: 
\item{cvAUC}{Cross-validated area under the curve estimate.}
\item{se}{Standard error.}
\item{ci}{A vector of length two containing the upper and lower bounds for the confidence interval.}
\item{confidence}{A number between 0 and 1 representing the confidence.}
\item{ic}{A vector of the influence function evaluated at observations.}
}
\description{
This function is nearly verbatim \link[cvAUC]{ci.cvAUC} from the cvAUC package. 
The only difference is that it additionally returns estimated influence functions.
}
