% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foi.R
\name{foiControl}
\alias{foiControl}
\title{Control options foir the FOI estimation method}
\usage{
foiControl(sigdig = 3, ..., posthoc = TRUE, interaction = NULL, fo = NULL)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{...}{Parameters used in the default `foceiConrol()`}

\item{posthoc}{Logical indicating if the estimation method should
calculate `foce` posthoc predicted parameters.}

\item{interaction}{Interaction term for the model; ignored by fo}

\item{fo}{Logical indicating if the estimation method is FO (first
order), but this is controlled by the estimation method so this
is ignored.}
}
\value{
foiControl object
}
\description{
This is related to the focei methods and uses most of their control
options.  Some are ignored, `posthoc` is an extra parameter
}
\examples{

foiControl()
}
\author{
Matthew L. Fidler
}
