% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de.R
\name{differential_evolution}
\alias{differential_evolution}
\title{Implementation of Differential Evolution metaheuristic algorithm.}
\usage{
differential_evolution(
  d = 10,
  np = 10,
  f = 0.5,
  cr = 0.9,
  nfes = 1000,
  features,
  data,
  is_time_series = FALSE
)
}
\arguments{
\item{d}{Dimension of the problem (default: 10).}

\item{np}{Population size (default: 10).}

\item{f}{The differential weight, controlling the amplification of the difference vector (default: 0.5).}

\item{cr}{The crossover probability, determining the probability of a component being replaced (default: 0.9).}

\item{nfes}{The maximum number of function evaluations (default: 1000).}

\item{features}{A list containing information about features, including type and bounds.}

\item{data}{A data frame representing instances in the dataset.}

\item{is_time_series}{A boolean indicating whether the dataset is time series.}
}
\value{
A list containing the best solution, its fitness value, and the number of function evaluations and list of identified association rules.
}
\description{
This function uses Differential Evolution, a stochastic population-based optimization algorithm,
to find the optimal numerical association rule.
}
