% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_oaproc.R
\name{get_elev_along_path}
\alias{get_elev_along_path}
\title{Get Elevation Along Path (experimental)}
\usage{
get_elev_along_path(points, num_pts, res = 1, status = TRUE)
}
\arguments{
\item{points}{sf data.frame containing a point column.}

\item{num_pts}{numeric number of points to retrieve along the cross section.}

\item{res}{integer resolution of 3D Elevation Program data to request.
Must be on of: 1, 3, 5, 10, 30, 60.}

\item{status}{logical}
}
\value{
sf data.frame containing points retrieved. Names include
"id", "distance_m", "elevation_m", "spatial_ref", "geometry",
and ".group". .group tracks which input point each set of output
points belongs to.
}
\description{
Uses a cross section retrieval web services to retrieve elevation
 along a path.
}
\examples{
\donttest{
point1 <- sf::st_sfc(sf::st_point(x = c(-105.9667, 36.17602)), crs = 4326)
point2 <- sf::st_sfc(sf::st_point(x = c(-105.97768, 36.17526)), crs = 4326)
point3 <- sf::st_sfc(sf::st_point(x = c(-105.98869, 36.17450)), crs = 4326)

points <- sf::st_as_sf(c(point1, point2, point3))

(xs <- get_elev_along_path(points, 100))

if(inherits(xs, "sf")) {

bbox <- sf::st_bbox(xs) + c(-0.005, -0.005, 0.005, 0.005)

nhdplusTools::plot_nhdplus(bbox = bbox, cache_data = FALSE)

plot(sf::st_transform(sf::st_geometry(xs), 3857), pch = ".", add = TRUE, col = "red")
plot(sf::st_transform(sf::st_sfc(point1, crs = 4326), 3857), add = TRUE)
plot(sf::st_transform(sf::st_sfc(point2, crs = 4326), 3857), add = TRUE)
plot(sf::st_transform(sf::st_sfc(point3, crs = 4326), 3857), add = TRUE)

plot(xs$distance_m, xs$elevation_m)
}

}

}
