% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neurovol.R
\name{NeuroVol}
\alias{NeuroVol}
\title{NeuroVol: 3D Neuroimaging Volume Class}
\usage{
NeuroVol(data, space, label = "", indices = NULL)
}
\arguments{
\item{data}{A 3D array containing the volumetric data.}

\item{space}{An object of class \code{\linkS4class{NeuroSpace}} defining the spatial properties.}

\item{label}{A character string providing a label for the volume (default: "").}

\item{indices}{An optional vector of indices for sparse representation (default: NULL).}
}
\value{
A \code{NeuroVol} object.
}
\description{
The \code{NeuroVol} class encapsulates 3D volumetric neuroimaging data. It provides methods
for accessing slices, performing spatial transformations, and integrating with the spatial
reference provided by \code{\linkS4class{NeuroSpace}}.
}
\examples{
bspace <- NeuroSpace(c(64,64,64), spacing=c(1,1,1))
dat <- array(rnorm(64*64*64), c(64,64,64))
bvol <- NeuroVol(dat,bspace, label="test")
}
