% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{make_family_id}
\alias{make_family_id}
\title{Construct family id vector from pedigree trio information}
\usage{
make_family_id(id, fid, mid)
}
\arguments{
\item{id}{Numeric vector of ids}

\item{fid}{Numeric vector of ids of the father. This should be NA or 0 for a founder.}

\item{mid}{Numeric vector of ids of the mother. This should be NA or 0 for a founder.}
}
\value{
Returns an integer vector giving the family index of each individual
}
\description{
Create a vector of length n, giving the family id of
each subject.  If the pedigree is totally connected, then everyone
will end up in tree 1, otherwise the tree numbers represent the
disconnected subfamilies.  Singleton subjects each have unique
family numbers.

No check is done to ensure that the id, fid, and mid actually refer to proper family structure.
References to ids in the fid and mid arguments that are not part of the id vector are considered founders and are thus replaced by NA or 0s after being used to group full and half-sibs.
}
\examples{

id <- 1:11
fid <- c(NA, NA, 1, 1, NA, 23, 45, 5, 5, 7, NA)
mid <- c(NA, NA, 2, 2, 65, NA, 46, 6, 6, 6, 0)
make_family_id(id, fid, mid)

}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{manip}
