% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mksib.R
\name{mksib}
\alias{mksib}
\title{Generate variables (or lists) of siblings from a file of ids of persons and
their father and mother.}
\usage{
mksib(obj, ns = 3, expand.vars = TRUE)
}
\arguments{
\item{obj}{A 3-column structure with column names \code{id}, \code{pid}
(paternal id) and \code{mid} (maternal id).}

\item{ns}{Integer. The maximal no of sibs of each type to include in the
result if sibling ids are required in separate columns.}

\item{expand.vars}{Logical. Should the sibling ids be returned in separate
columns. If \code{FALSE} they will be returned i three columns of lists.}
}
\value{
A \code{data.table} with the columns of the \code{obj} and columns
for \code{ns} maternal, paternal and full sibs, named \code{ms1},
\code{ms2}, \ldots{} \code{ps1}, \code{ps2}, \ldots{} \code{fs1},
\code{fs2}.

If \code{expand.vars=FALSE} there will instead be three columns of lists
named \code{msibs}, \code{psibs} and \code{fsibs}.
}
\description{
The function generates for each person lists of maternal half-sibs, paternal
half-sibs and full sibs. Optionally these are expanded to separate columns
in a data.table.
}
\details{
There are no checks of persons being both mother and father, nor being its
own parent and incest checks are not performed. In other words, the
\code{obj} is assumed to be sane, but possibly immoral.
}
\examples{

library( data.table )
id <- 1:12
pid <- c(NA,  1, 1, 1, NA, 23, 45, 5, 5, 7, 12, NA)
mid <- c(NA, NA, 2, 2, 12, NA, 46, 6, 6, 6, NA, 12)
indd <- data.table( id, mid, pid )
indata <- copy( indd )
indata

str( xx <- mksib( indata ) )
xx

zz <- mksib( indata, 2, e=FALSE )
zz

}
\author{
Claus Thorn Ekstrøm, \email{ekstrom@sund.ku.dk}, Bendix Carstensen,
\email{b@bxc.dk}
}
\keyword{manip}
