% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-meta.R
\name{ns_write_meta}
\alias{ns_write_meta}
\alias{ns_write_meta.default}
\alias{ns_write_meta.ns_meta}
\title{Write meta-data to file}
\usage{
ns_write_meta(meta, path, ...)

\method{ns_write_meta}{default}(meta, path, ...)

\method{ns_write_meta}{ns_meta}(meta, path, ...)
}
\arguments{
\item{meta}{object of class ns_meta class}

\item{path}{file name or path}

\item{...}{other arguments to \code{\link[jsonlite]{write_json}}}
}
\value{
no return value. Writes a file to path.
}
\description{
Save meta-data information to a
file for safe keeping. The function
saves the data in json-format, which
best preserves the information.
}
\examples{
\dontrun{
form_id <- 1100000
my_meta <- ns_get_meta(form_id)
ns_write_meta(my_meta, "my/path/meta_110000.json")
}
}
