% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvgam_formulae.R
\name{mvgam_formulae}
\alias{mvgam_formulae}
\title{Details of formula specifications in \pkg{mvgam} models}
\description{
Details of formula specifications in \pkg{mvgam} models
}
\details{
\code{\link{mvgam}} will accept an observation model formula and an optional
process model formula (via the argument \code{trend_formula}). Neither of these formulae can
be specified as lists, contrary to the accepted behaviour in some \code{mgcv} or \code{brms} models.
\cr
\cr
Note that it is possible to supply an empty formula where
there are no predictors or intercepts in the observation model (i.e. \code{y ~ 0} or \code{y ~ -1}).
In this case, an intercept-only observation model will be set up but the intercept coefficient
will be fixed at zero. This can be handy if you wish to fit pure State-Space models where
the variation in the dynamic trend controls the average expectation, and/or where intercepts
are non-identifiable.
\cr
\cr
The formulae supplied to \code{\link{mvgam}} and \code{\link{jsdgam}}
are exactly like those supplied to
\code{\link{glm}} except that smooth terms,
\code{\link[mgcv]{s}},
\code{\link[mgcv]{te}},
\code{\link[mgcv]{ti}} and
\code{\link[mgcv]{t2}},
time-varying effects using \code{\link{dynamic}},
monotonically increasing (using \code{s(x, bs = 'moi')})
or decreasing splines (using \code{s(x, bs = 'mod')};
see \code{\link{smooth.construct.moi.smooth.spec}} for
details), as well as
Gaussian Process functions using \code{\link[brms]{gp}} and offsets using
\code{\link[stats]{offset}}
can be added to the right hand side (and \code{.} is not supported in \code{mvgam} formulae).
\cr
\cr
Further details on specifying different kinds of smooth functions, and how to control their behaviours
by modifying their potential complexities and / or how the penalties behave, can be found in the
extensive documentation for the \code{mgcv} package.
}
\seealso{
\code{\link{mvgam}},
\code{\link[mgcv]{formula.gam}},
\code{\link[mgcv]{gam.models}},
\code{\link[mgcv]{jagam}},
\code{\link[mgcv]{gam}},
\code{\link[mgcv]{s}},
\code{\link[brms]{gp}},
\code{\link[stats]{formula}}
}
\author{
Nicholas J Clark
}
