% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Import data into an mpactr object.}
\usage{
import_data(peak_table, meta_data, format = "none")
}
\arguments{
\item{peak_table}{The file path or valid \code{https} url to your feature table
file.}

\item{meta_data}{The file path to your meta_data file or \code{data.frame}.}

\item{format}{The expected exported type of your peak table, can be
one of "Progenesis", "Metaboscape", "None".}
}
\value{
an \code{mpactr_object}.
}
\description{
\code{import_data()} takes two file paths, one for the pre-processed feature
table and one for sample metadata. Both files should be .csv.
}
\details{
mpactr requires a peak table and meta data as input. Files are expected to be
comma separated files (\emph{.csv}).
\enumerate{
\item \code{peak_table}: a peak table where rows are expected to be compounds. mpactr
supports import of feature table files from multiple tools through the
\code{format} argument. Currently supported value for \code{format} are "Progenesis",
"Metaboscape", or "None".
}

\code{format} = "Progenesis." allows users to provide a feature table exported by
Progenesis. To export a compatible peak table in Progenesis, navigate to the
\emph{Review Compounds} tab then File -> Export Compound Measurements. Select
the following properties: Compound, m/z, Retention time (min), and Raw
abundance and click ok.

\code{format} = "Metaboscape" allows users to provide a feature table exported by
Metaboscape with default settings. The import function will save the raw peak
table in the \code{mpactr_object} and store a formatted peak table for filtering.
Reformatting includes selecting "FEATURE_ID", "RT", "PEPMASS", and sample
columns. Sample columns are determined from the "Injection" column in
\code{meta_data} (see below). "PEPMASS" is converted to m/z using the "ADDUCT"
column and compound metadata columns are renamed for mpactr.

\code{format} = "None" allows users to provide a feature table file in the
expected format. This can be useful if you have a file from another tool and
want to manually format it in R. The table rows are expected to be individual
features, while columns are compound metadata and samples. The feature table
must have the compound metadata columns "Compound", "mz", and "rt". Where
"Compound" is the compound id, and can be \code{numeric} or \code{character}. "mz" is
the compound m/z, and should be \code{numeric}. "rt" is the retention time, in
minutes, and should be \code{numeric}. The remaining columns should be samples,
and match the names in the "Injection" column of the \code{meta_data} file.
2. \code{meta_data}: a table with sample information. Either a file path or
\code{data.frame} can be supplied. At minimum the following columns are expected:
"Injection", "Sample_Code", and "Biological_Group". "Injection" is the sample
name and is expected to match sample column names in the \code{peak_table}.
"Sample_Code" is the id for technical replicate groups. "Biological_Group"
is the id for biological replicate groups. Other sample metadata can be
added, and is encouraged for downstream analysis following filtering with
mpactr.
}
\examples{
data <- import_data(
  example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

meta_data <- read.csv(example_path("metadata.csv"))
data <- import_data(example_path("coculture_peak_table.csv"),
  meta_data,
  format = "Progenesis"
)

}
