% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survData.R, R/survDataCheck.R
\name{survData}
\alias{survData}
\alias{survDataCheck}
\title{Creates a data set for survival analysis}
\usage{
survData(x)

survDataCheck(data, diagnosis.plot = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} containing the following four columns:
\itemize{
\item \code{replicate}: a vector of any class \code{numeric}, \code{character} or \code{factor} for replicate
identification. A given replicate value should identify the same group of
individuals followed in time
\item \code{conc}: a vector of class \code{numeric} with tested concentrations
(positive values, may contain NAs)
\item \code{time}: a vector of class \code{integer} with time points, minimal value must be 0
\item \code{Nsurv}: a vector of class \code{integer} providing the number of
alive individuals at each time point for each concentration and each replicate
(may contain NAs)
}}

\item{data}{any object}

\item{diagnosis.plot}{if \code{TRUE}, the function may produce diagnosis plots}
}
\value{
A dataframe of class \code{survData} and column \code{replicate} as \code{factor}.

The function returns a dataframe of class \code{msgTable} and \code{data.frame} with two columns: \code{id} and \code{msg} of
character strings. When no error is detected the object is empty.
Here is the list of possible error \code{id}s with their meaning:
\tabular{rl}{
\code{dataframeExpected} \tab an object of class \code{data.frame} is expected \cr
\code{missingColumn} \tab at least one expected column heading is missing \cr
\code{firstTime0} \tab the first time point for some (concentration, replicate) couples is not 0 \cr
\code{concNumeric} \tab column \code{conc} contains a value of class other than \code{numeric} \cr
\code{timeNumeric} \tab column \code{time} contains a value of class other than \code{numeric} \cr
\code{NsurvInteger} \tab column \code{Nsurv} contains a value of class other than \code{integer} \cr
\code{tablePositive} \tab some data are negative \cr
\code{Nsurv0T0} \tab \code{Nsurv} is 0 at time 0 for some (concentration, replicate) \cr
\code{duplicateID} \tab there are two identical (\code{replicate}, \code{time}) couples \cr
\code{NsurvIncrease} \tab \code{Nsurv} increases at some time point of some (concentration, replicate) \cr
\code{maxTimeDiffer} \tab maximum time for concentration is lower than maximum time for survival \cr
}
}
\description{
This function creates a \code{survData} object from experimental data
provided as a \code{data.frame}. The resulting object
can then be used for plotting and model fitting. It can also be used
to generate \emph{individual-time} estimates.

The \code{survDataCheck} function can be used to check if an object
containing survival data is formatted according to the expectations of the
\code{survData} function.
}
\details{
Survival data sets can be under either constant or time-variable exposure profile. The
resulting object, in addition to its \code{survData} class, inherits the
class \code{survDataCstExp} or \code{survDataVarExp} respectively.

The \code{x} argument describes experimental results from a survival
toxicity test. Each line of the \code{data.frame}
corresponds to one experimental measurement, that is a number of alive
individuals at a given concentration at a given time point and in a given replicate.
 Note that either the concentration
or the number of alive individuals may be missing. The data set is inferred
to be under constant exposure if the concentration is constant for each
replicate and systematically available. The function \code{survData} fails if
\code{x} does not meet the
expected requirements. Please run \code{\link{survDataCheck}} to ensure
\code{x} is well-formed.
}
\note{
If an error of type \code{dataframeExpected} or \code{missingColumn} is
detected, the function \code{survDataCheck} is stopped before looking for
other errors.
}
\seealso{
\code{\link{survDataCheck}}

\code{\link{survData}}
}
\keyword{transformation}
