% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeInStates.R
\name{timeInStates}
\alias{timeInStates}
\alias{timeInStates.momentuHMM}
\alias{timeInStates.HMMfits}
\alias{timeInStates.miHMM}
\title{Calculate proportion of time steps assigned to each state (i.e. \dQuote{activity budgets})}
\usage{
timeInStates(m, by = NULL, alpha = 0.95, ncores = 1)

\method{timeInStates}{momentuHMM}(m, by = NULL, alpha = 0.95, ncores = 1)

\method{timeInStates}{HMMfits}(m, by = NULL, alpha = 0.95, ncores = 1)

\method{timeInStates}{miHMM}(m, by = NULL, alpha = 0.95, ncores = 1)
}
\arguments{
\item{m}{A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{HMMfits}} object.}

\item{by}{A character vector indicating any groupings by which to calculate the proportions, such as individual (\dQuote{ID}) or group-level (e.g. sex or age class) covariates. Default is \code{NULL} (no groupings are used).}

\item{alpha}{Significance level for calculating confidence intervals of pooled estimates. Default: 0.95. Ignored unless \code{m} is a \code{\link{miHMM}} or \code{\link{HMMfits}} object.}

\item{ncores}{Number of cores to use for parallel processing. Default: 1 (no parallel processing). Ignored unless \code{m} is a \code{\link{miHMM}} or \code{\link{HMMfits}} object.}
}
\value{
If \code{m} is a \code{\link{momentuHMM}} object, a data frame containing the estimated activity budgets for each state (grouped according to \code{by}).  If \code{m} is a \code{\link{miHMM}} or \code{\link{HMMfits}} object, a list containing the activity budget
estimates, standard errors, lower bounds, and upper bounds across all imputations.
}
\description{
Calculate proportion of time steps assigned to each state (i.e. \dQuote{activity budgets})
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m
timeInStates(m)
timeInStates(m, by = "ID")

}
