% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_imputation_da.R
\name{modsem_mimpute}
\alias{modsem_mimpute}
\title{Estimate a \code{modsem} model using multiple imputation}
\usage{
modsem_mimpute(
  model.syntax,
  data,
  method = "lms",
  m = 25,
  verbose = interactive(),
  se = c("simple", "full"),
  ...
)
}
\arguments{
\item{model.syntax}{\code{lavaan} syntax}

\item{data}{A dataframe with observed variables used in the model.}

\item{method}{Method to use:
\describe{
  \item{\code{"lms"}}{latent moderated structural equations (not passed to \code{lavaan}).}
  \item{\code{"qml"}}{quasi maximum likelihood estimation (not passed to \code{lavaan}).}
}}

\item{m}{Number of imputations to perform. More imputations will yield better estimates
but can also be (a lot) slower.}

\item{verbose}{Should progress be printed to the console?}

\item{se}{How should corrected standard errors be computed? Alternatives are:
\describe{
  \item{\code{"simple"}}{Uncorrected standard errors are only calculated once, in the first imputation.
                         The standard errors are thereafter corrected using the distribution of the
                         estimated coefficients from the different imputations.}
  \item{\code{"full"}}{Uncorrected standard errors are calculated and aggregated for each imputation.
                       This can give more accurate results, but can be (a lot) slower.
                       The standard errors are thereafter corrected using the distribution of the
                       estimated coefficients from the different imputations.}
}}

\item{...}{Arguments passed to \code{\link{modsem}}.}
}
\description{
Estimate a \code{modsem} model using multiple imputation
}
\details{
\code{modsem_impute} is currently only available for the DA approaches
 (LMS and QML). It performs multiple imputation using \code{Amelia::amelia}
 and returns aggregated coefficients from the multiple imputations, along with
 corrected standard errors.
}
\examples{

m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'

oneInt2 <- oneInt

set.seed(123)
k <- 200
I <- sample(nrow(oneInt2), k, replace = TRUE)
J <- sample(ncol(oneInt2), k, replace = TRUE)
for (k_i in seq_along(I)) oneInt2[I[k_i], J[k_i]] <- NA

\dontrun{
est <- modsem_mimpute(m1, oneInt2, m = 25)
summary(est)
}
}
