% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized_solution_da.R
\name{standardize_model}
\alias{standardize_model}
\title{Standardize a fitted \code{modsem_da} model}
\usage{
standardize_model(model, monte.carlo = FALSE, mc.reps = 10000, ...)
}
\arguments{
\item{model}{A fitted object of class \code{modsem_da}.
Passing any other object triggers an error.}

\item{monte.carlo}{Logical. If \code{TRUE}, the function will use Monte Carlo
simulation to obtain the standard errors of the standardized estimates.
If \code{FALSE}, the delta method is used.
Default is \code{FALSE}.}

\item{mc.reps}{Number of Monte Carlo replications. Default is 10,000.
Ignored if \code{monte.carlo = FALSE}.}

\item{...}{Arguments passed on to other functions}
}
\value{
The same object (returned invisibly) with three slots overwritten  
\describe{
  \item{\code{$parTable}}{Parameter table whose columns \code{est} and \code{std.error}
        now hold standardized estimates and their (delta-method)
        standard errors, as produced by \code{\link{standardized_estimates}()}.}
  \item{\code{$coefs}}{Named numeric vector of standardized coefficients.
        Intercepts (operator \code{~1}) are removed, because a standardized
        variable has mean 0 by definition.}
  \item{\code{$vcov}}{Variance–covariance matrix corresponding to the updated
        coefficient vector.  Rows/columns for intercepts are dropped, and
        the sub-matrix associated with rescaled parameters is adjusted 
        so that its diagonal equals the squared standardized standard errors.}
}
The object keeps its class attributes, allowing seamless use by downstream
S3 methods such as \code{summary()}, \code{coef()}, or \code{vcov()}.

Because the function merely transforms existing estimates, \emph{parameter
constraints imposed through shared labels remain satisfied}.
}
\description{
\code{standardize_model()} post-processes the output of
\code{\link{modsem_da}()} (or of \code{\link{modsem}())} when \code{method = "lms"} /
\code{method = "qml"}), replacing the \emph{unstandardized} coefficient vector
(\code{$coefs}) and its variance–covariance matrix (\code{$vcov}) with \emph{fully
standardized} counterparts (including the measurement model).The procedure is purely
algebraic— \strong{no re-estimation is carried out} —and is therefore fast and
deterministic.
}
\examples{
\dontrun{
# Latent interaction estimated with LMS and standardized afterwards
syntax <- "
  X =~ x1 + x2 + x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3
  Y ~ X + Z + X:Z
"
fit  <- modsem_da(syntax, data = oneInt, method = "lms")
sfit <- standardize_model(fit, monte.carlo = TRUE)

# Compare unstandardized vs. standardized summaries
summary(fit)  # unstandardized
summary(sfit) # standardized 
}

}
\seealso{
\describe{
   \item{\code{\link{standardized_estimates}()}}{Obtains the fully standardized
         parameter table used here.}
   \item{\code{\link{modsem}()}}{Fit model using LMS or QML approaches.}
   \item{\code{\link{modsem_da}()}}{Fit model using LMS or QML approaches.}
}
}
