% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_graph.R
\name{model_descriptor_to_module}
\alias{model_descriptor_to_module}
\title{Create a nn_graph from ModelDescriptor}
\usage{
model_descriptor_to_module(
  model_descriptor,
  output_pointers = NULL,
  list_output = FALSE
)
}
\arguments{
\item{model_descriptor}{(\code{\link{ModelDescriptor}})\cr
Model Descriptor. \code{pointer} is ignored, instead \code{output_pointer} values are used. \verb{$graph} member is
modified by-reference.}

\item{output_pointers}{(\code{list} of \code{character})\cr
Collection of \code{pointer}s that indicate what part of the \code{model_descriptor$graph} is being used for output.
Entries have the format of \code{ModelDescriptor$pointer}.}

\item{list_output}{(\code{logical(1)})\cr
Whether output should be a list of tensors. If \code{FALSE}, then \code{length(output_pointers)} must be 1.}
}
\value{
\code{\link{nn_graph}}
}
\description{
Creates the \code{\link{nn_graph}} from a \code{\link{ModelDescriptor}}. Mostly for internal use, since the \code{\link{ModelDescriptor}} is in
most circumstances harder to use than just creating \code{\link{nn_graph}} directly.
}
\seealso{
Other Graph Network: 
\code{\link{ModelDescriptor}()},
\code{\link{TorchIngressToken}()},
\code{\link{mlr_learners_torch_model}},
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{model_descriptor_to_learner}()},
\code{\link{model_descriptor_union}()},
\code{\link{nn_graph}()}
}
\concept{Graph Network}
