% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_bacc.R
\name{bacc}
\alias{bacc}
\title{Balanced Accuracy}
\usage{
bacc(truth, response, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{(\code{factor()})\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
labels
in multiclass classification tasks.
}
\details{
The Balanced Accuracy computes the weighted balanced accuracy, suitable for imbalanced data sets.
It is defined analogously to the definition in \href{https://scikit-learn.org/}{sklearn}.

First, all sample weights \eqn{w_i} are normalized per class so that each class has the same influence:
\deqn{
 \hat{w}_i = \frac{w_i}{\sum_{j=1}^n w_j \cdot \mathbf{1}(t_j = t_i)}.
}{
 w_hat[i] = w[i] / sum((t == t[i]) * w[i]).
}
The Balanced Accuracy is then calculated as
\deqn{
 \frac{1}{\sum_{i=1}^n \hat{w}_i} \sum_{i=1}^n \hat{w}_i \cdot \mathbf{1}(r_i = t_i).
}{
 1 / sum(w_hat) * sum((r == t) * w_hat).
}
This definition is equivalent to \code{\link[=acc]{acc()}} with class-balanced sample weights.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
bacc(truth, response)
}
\references{
Brodersen KH, Ong CS, Stephan KE, Buhmann JM (2010).
\dQuote{The Balanced Accuracy and Its Posterior Distribution.}
In \emph{2010 20th International Conference on Pattern Recognition}.
\doi{10.1109/icpr.2010.764}.

Guyon I, Bennett K, Cawley G, Escalante HJ, Escalera S, Ho TK, Macia N, Ray B, Saeed M, Statnikov A, Viegas E (2015).
\dQuote{Design of the 2015 ChaLearn AutoML challenge.}
In \emph{2015 International Joint Conference on Neural Networks (IJCNN)}.
\doi{10.1109/ijcnn.2015.7280767}.
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mauc_aunu}()},
\code{\link{mbrier}()},
\code{\link{mcc}()},
\code{\link{zero_one}()}
}
\concept{Classification Measures}
\concept{classification_measure}
