% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleGroup-methods.R
\name{coef-method}
\alias{coef-method}
\alias{coef,SingleGroupClass-method}
\alias{coef,MultipleGroupClass-method}
\alias{coef,MixedClass-method}
\alias{coef,DiscreteClass-method}
\alias{coef,MixtureClass-method}
\title{Extract raw coefs from model object}
\usage{
\S4method{coef}{SingleGroupClass}(
  object,
  CI = 0.95,
  printSE = FALSE,
  rotate = "none",
  Target = NULL,
  IRTpars = FALSE,
  rawug = FALSE,
  as.data.frame = FALSE,
  simplify = FALSE,
  unique = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{SingleGroupClass},
\code{MultipleGroupClass}, or \code{MixedClass}}

\item{CI}{the amount of converged used to compute confidence intervals; default is
95 percent confidence intervals}

\item{printSE}{logical; print the standard errors instead of the confidence intervals? When
\code{IRTpars = TRUE} then the delta method will be used to compute the associated standard errors
from mirt's default slope-intercept form}

\item{rotate}{see \code{summary} method for details. The default rotation is \code{'none'}}

\item{Target}{a dummy variable matrix indicting a target rotation pattern}

\item{IRTpars}{logical; convert slope intercept parameters into traditional IRT parameters?
Only applicable to unidimensional models or models with simple structure (i.e., only one non-zero slope).
If a suitable ACOV estimate was computed in the fitted
model, and \code{printSE = FALSE}, then suitable CIs will be included based on the delta
method (where applicable)}

\item{rawug}{logical; return the untransformed internal g and u parameters?
If \code{FALSE}, g and u's are converted with the original format along with delta standard errors}

\item{as.data.frame}{logical; convert list output to a data.frame instead?}

\item{simplify}{logical; if all items have the same parameter names (indicating they are
of the same class) then they are collapsed to a matrix, and a list of length 2 is returned
containing a matrix of item parameters and group-level estimates}

\item{unique}{return the vector of uniquely estimated parameters}

\item{verbose}{logical; allow information to be printed to the console?}

\item{...}{additional arguments to be passed}
}
\description{
Return a list (or data.frame) of raw item and group level coefficients. Note that while
the output to the console is rounded to three digits, the returned list of objects is not.
Hence, elements from \code{cfs <- coef(mod); cfs[[1]]} will contain the non-rounded results (useful
for simulations).
}
\examples{

\dontrun{
dat <- expand.table(LSAT7)
x <- mirt(dat, 1)
coef(x)
coef(x, IRTpars = TRUE)
coef(x, simplify = TRUE)

#with computed information matrix
x <- mirt(dat, 1, SE = TRUE)
coef(x)
coef(x, printSE = TRUE)
coef(x, as.data.frame = TRUE)

#two factors
x2 <- mirt(Science, 2)
coef(x2)
coef(x2, rotate = 'varimax')

}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{summary-method}}
}
