% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid.R
\name{ggmid}
\alias{ggmid}
\alias{ggmid.mid}
\alias{autoplot.mid}
\title{Plot MID Component Functions with ggplot2}
\usage{
ggmid(object, ...)

\method{ggmid}{mid}(
  object,
  term,
  type = c("effect", "data", "compound"),
  theme = NULL,
  intercept = FALSE,
  main.effects = FALSE,
  data = NULL,
  limits = c(NA, NA),
  jitter = 0.3,
  resolution = c(100L, 100L),
  ...
)

\method{autoplot}{mid}(object, ...)
}
\arguments{
\item{object}{a "mid" object to be visualized.}

\item{...}{optional parameters passed to the main plotting layer.}

\item{term}{a character string specifying the component function to be plotted.}

\item{type}{the plotting style. One of "effect", "data" or "compound".}

\item{theme}{a character string or object defining the color theme. See \code{\link{color.theme}} for details.}

\item{intercept}{logical. If \code{TRUE}, the intercept is added to the MID values.}

\item{main.effects}{logical. If \code{TRUE}, main effects are included in the interaction plot.}

\item{data}{a data frame to be plotted with the corresponding MID values. If not provided, data is automatically extracted based on the function call.}

\item{limits}{a numeric vector of length two specifying the limits of the plotting scale. \code{NA} values are replaced by the minimum and/or maximum MID values.}

\item{jitter}{a numeric value specifying the amount of jitter for the data points.}

\item{resolution}{an integer or vector of two integers specifying the resolution of the raster plot for interactions.}
}
\value{
\code{ggmid.mid()} returns a "ggplot" object.
}
\description{
\code{ggmid()} is an S3 generic function for creating various visualizations from MID-related objects using \strong{ggplot2}.
For "mid" objects (i.e., fitted MID models), it visualizes a single component function specified by the \code{term} argument.
}
\details{
For "mid" objects, \code{ggmid()} creates a "ggplot" object that visualizes a component function of the fitted MID model.

The \code{type} argument controls the visualization style.
The default, \code{type = "effect"}, plots the component function itself.
In this style, the plotting method is automatically selected based on the effect's type:
a line plot for quantitative main effects; a bar plot for qualitative main effects; and a raster plot for interactions.
The \code{type = "data"} option creates a scatter plot of \code{data}, colored by the values of the component function.
The \code{type = "compound"} option combines both approaches, plotting the component function alongside the data points.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])

# Plot a quantitative main effect
ggmid(mid, "carat")

# Plot a qualitative main effect
ggmid(mid, "clarity")

# Plot an interaction effect with data points and a raster layer
ggmid(mid, "carat:clarity", type = "compound", data = diamonds[idx, ])

# Use a different color theme
ggmid(mid, "clarity:color", theme = "RdBu")
}
\seealso{
\code{\link{interpret}}, \code{\link{ggmid.mid.importance}}, \code{\link{ggmid.mid.conditional}}, \code{\link{ggmid.mid.breakdown}}, \code{\link{plot.mid}}
}
