% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/80_class.R
\name{as_metabodecon_class}
\alias{as_metabodecon_class}
\alias{as_spectrum}
\alias{as_ispec}
\alias{as_idecon}
\alias{as_decon0}
\alias{as_decon1}
\alias{as_decon2}
\alias{as_spectra}
\alias{as_ispecs}
\alias{as_idecons}
\alias{as_decons0}
\alias{as_decons1}
\alias{as_decons2}
\title{Convert to a Metabodecon Class}
\usage{
as_spectrum(x, sf = c(1000, 1e+06))

as_ispec(x, sf = c(1000, 1e+06))

as_idecon(x)

as_decon0(x, sf = NULL, spectrum = NULL, optional = TRUE)

as_decon1(
  x,
  sf = c(1000, 1e+06),
  spectrum = NULL,
  sfr = NULL,
  wshw = NULL,
  bwc = 2
)

as_decon2(
  x,
  sf = c(1000, 1e+06),
  spectrum = NULL,
  sfr = NULL,
  wshw = NULL,
  bwc = 2
)

as_spectra(
  x,
  file_format = "bruker",
  expno = 10,
  procno = 10,
  raw = FALSE,
  silent = TRUE,
  force = FALSE
)

as_ispecs(x, sf = c(1000, 1e+06))

as_idecons(x)

as_decons0(x, sfs = list(c(1000, 1e+06)), spectra = list(NULL), nworkers = 1)

as_decons1(
  x,
  sfs = list(c(1000, 1e+06)),
  spectra = list(NULL),
  sfrs = list(NULL),
  wshws = list(NULL),
  bwc = 2,
  nworkers = 1
)

as_decons2(
  x,
  sfs = list(c(1000, 1e+06)),
  spectra = list(NULL),
  sfrs = list(NULL),
  wshws = list(NULL),
  bwc = 2,
  nworkers = 1
)
}
\arguments{
\item{x}{The object to convert.}

\item{sf}{Scale factor. Only required if \code{x} is a decon0 object.}

\item{spectrum, spectra}{The \code{spectrum}/\code{spectra} object corresponding to \code{x} as returned by
\code{\link[=read_spectrum]{read_spectrum()}} / \link{read_spectra}. Only required if \code{x} is a decon0 object.}

\item{optional}{Logical. If \code{TRUE}, the two optional elements \code{signal_free_region} and
\code{range_water_signal_ppm} are included in the returned \code{decon0} object.}

\item{sfr, sfrs}{\code{sfr} should be a vector specifying the borders of the signal free region.
\code{sfrs} should be a list of such vectors. Only required if \code{x} is a \code{decon0}
object where element \code{signal_free_region} is missing (or a \code{decons0} objected
containing such \code{decon0} objects).}

\item{wshw, wshws}{\code{wshw} should specify the half width of the water signal region. \code{wshws}
should be a list of such values. Only required if \code{x} is a \code{decon0} object
where element \code{range_water_signal_ppm} is missing (or a \code{decons0} objected
containing such \code{decon0} objects).}

\item{bwc}{Level of backwards compatibility. If \code{bwc == 0}, bug fixes introduced after
version 0.2.2 of Metabodecon are not used. If \code{bwc == 1}, new features
introduced after version 0.2.2 of Metabodecon (e.g. faster algorithms) are
not used. If \code{bwc == 2}, all bug fixes and features introduced after version
0.2.2 are used. Support for \code{bwc == 0} will be removed in 'metabodecon v2.0'.}

\item{file_format}{The file_format of the spectrum file. E.g. \code{"bruker"} or \code{"jcampdx"}.}

\item{expno, procno}{The experiment/processing number for the file. E.g. \code{"10"}. Only relevant if
\code{file_format} equals \code{"bruker"}. For details see section \href{https://spang-lab.github.io/metabodecon/articles/FAQ.html#file-structure}{File Structure} in
the metabodecon FAQ.}

\item{raw}{If \code{FALSE}, scales the returned signal intensities based on information
available in the spectrum metadata, in particular \code{NC_proc}. For details see
\code{processing-reference.pdf}, available at \url{https://www.bruker.com/en.html} at
section 'Services & Support > Documentation & Manuals > Magnetic Resonance >
Acquisition & Processing > TopSpin Processing Commands and Parameters'
(requires login).}

\item{silent}{If \code{TRUE}, no output will be printed to the console.}

\item{force}{If \code{TRUE}, try to continue when encountering errors and print info messages
instead. To hide these messages as well, set \code{silent = TRUE}.}

\item{sfs}{List of scale factors. Only required if \code{x} is a list of decon0
objects.}

\item{nworkers}{Number of workers for parallel processing.}
}
\value{
An object of the specified class.
}
\description{
Convert an object to a Metabodecon class.
}
\examples{
dirpath <- metabodecon_file("sim_subset")
spectra <- read_spectra(dirpath)
spectrum <- spectra[[1]]
decons1 <- generate_lorentz_curves_sim(spectra)
decon1 <- generate_lorentz_curves_sim(spectrum)
decon2 <- as_decon2(decon1)
}
