/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton;

import choco.kernel.common.util.objects.DoubleLinkedList;
import choco.kernel.model.constraints.automaton.LayeredDFA;
import choco.kernel.model.constraints.automaton.LightState;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;

public class State
extends LightState {
    protected LayeredDFA auto;
    protected int level;
    protected int idxLevel;
    private State[] delta;
    protected DoubleLinkedList transitions;
    protected Hashtable<State, BitSet> hashPred;

    public State(LayeredDFA a, int level) {
        this.auto = a;
        this.idx = this.auto.getNextIdx();
        this.delta = new State[a.domSizes[level]];
        this.transitions = new DoubleLinkedList(a.domSizes[level]);
        this.hashPred = new Hashtable();
        this.level = level;
        this.idxLevel = this.auto.levelStates[level].size();
        this.auto.levelStates[level].add(this);
    }

    public State(State origin) {
        this.auto = origin.auto;
        this.level = origin.level;
        this.idx = this.auto.getNextIdx();
        this.delta = new State[origin.auto.domSizes[this.level]];
        System.arraycopy(origin.delta, 0, this.delta, 0, origin.delta.length);
        this.transitions = new DoubleLinkedList(origin.transitions);
        this.hashPred = new Hashtable();
        this.clonePred(origin);
        this.idxLevel = this.auto.levelStates[this.level].size();
        this.auto.levelStates[this.level].add(this);
    }

    public void clonePred(State origin) {
        origin.transitions.restart();
        while (origin.transitions.hasNext()) {
            int i = origin.transitions.next();
            BitSet bsn = (BitSet)origin.delta[i].hashPred.get(origin).clone();
            origin.delta[i].hashPred.put(this, bsn);
        }
    }

    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public int getLevel() {
        return this.level;
    }

    public void setIdxLevel(int idxLevel) {
        this.idxLevel = idxLevel;
    }

    public int getIdxLevel() {
        return this.idxLevel;
    }

    protected State getNext(int value) {
        return this.delta[value];
    }

    protected boolean hasNext(int value) {
        return this.delta[value] != null;
    }

    protected void retraitTransition(State st, int value) {
        if (this.hashPred.containsKey(st)) {
            BitSet vals = this.hashPred.get(st);
            vals.clear(value);
            this.hashPred.put(st, vals);
            if (vals.isEmpty()) {
                this.hashPred.remove(st);
            }
            if (this.hashPred.isEmpty()) {
                this.resetState();
                this.auto.removeState(this);
            }
        }
    }

    protected void removeIfNoPred() {
        if (this.hashPred.isEmpty()) {
            this.resetState();
            this.auto.removeState(this);
        }
    }

    protected void ajoutInTransition(State st, int value) {
        if (this.hashPred.containsKey(st)) {
            BitSet vals = this.hashPred.get(st);
            vals.set(value);
            this.hashPred.put(st, vals);
        } else {
            BitSet vals = new BitSet();
            vals.set(value);
            this.hashPred.put(st, vals);
        }
    }

    protected void resetState() {
        this.removeOutTransitions();
    }

    protected void remplaceRef(State st1) {
        Enumeration<State> e = this.hashPred.keys();
        while (e.hasMoreElements()) {
            BitSet bs;
            State stPred = e.nextElement();
            stPred.remplaceNext(st1, this.hashPred.get(stPred));
            if (st1.hashPred.containsKey(stPred)) {
                bs = st1.hashPred.get(stPred);
                bs.or(this.hashPred.get(stPred));
                st1.hashPred.put(stPred, bs);
                continue;
            }
            bs = this.hashPred.get(stPred);
            st1.hashPred.put(stPred, bs);
        }
        this.hashPred.clear();
    }

    protected void remplaceNext(State st, BitSet bs) {
        int value = bs.nextSetBit(0);
        while (value >= 0) {
            this.delta[value] = st;
            value = bs.nextSetBit(value + 1);
        }
    }

    protected void removeInTransitions() {
        Enumeration<State> e = this.hashPred.keys();
        while (e.hasMoreElements()) {
            State stPred = e.nextElement();
            stPred.deleteNext(this.hashPred.get(stPred));
        }
        this.hashPred.clear();
    }

    private void deleteNext(BitSet bs) {
        int value = bs.nextSetBit(0);
        while (value >= 0) {
            this.transitions.removeVal(value);
            this.delta[value] = null;
            value = bs.nextSetBit(value + 1);
        }
    }

    protected void removeOutTransitions() {
        this.transitions.restart();
        while (this.transitions.hasNext()) {
            int t = this.transitions.next();
            this.delta[t].hashPred.remove(this);
        }
    }

    protected boolean addNext(State st, int value) {
        if (this.delta[value] == null) {
            this.transitions.addVal(value);
        } else {
            if (this.delta[value] == st) {
                return false;
            }
            this.delta[value].retraitTransition(this, value);
        }
        st.ajoutInTransition(this, value);
        this.delta[value] = st;
        return true;
    }

    protected void removeNext(int value) {
        if (this.delta[value] != null) {
            this.transitions.removeVal(value);
            this.delta[value].retraitTransition(this, value);
            this.delta[value] = null;
        }
    }

    protected boolean equalState(State st) {
        if (this.transitions.getSize() != st.transitions.getSize()) {
            return false;
        }
        this.transitions.restart();
        while (this.transitions.hasNext()) {
            int t = this.transitions.next();
            if (this.delta[t] == st.delta[t]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(State st) {
        return this.idx == st.idx;
    }

    protected boolean hasSuccessor() {
        return this.transitions.getSize() != 0;
    }

    protected LightState convertState(Hashtable ht) {
        int cTab = 0;
        this.trPred = new LightState.Arcs[this.hashPred.size()];
        Enumeration<State> e = this.hashPred.keys();
        while (e.hasMoreElements()) {
            State cNode = e.nextElement();
            BitSet predBs = this.hashPred.get(cNode);
            this.trPred[cTab] = new LightState.Arcs((LightState)ht.get(cNode), predBs);
            ++cTab;
        }
        this.htransitions = new Hashtable();
        this.transitions.restart();
        while (this.transitions.hasNext()) {
            int t = this.transitions.next();
            this.htransitions.put(t, ht.get(this.delta[t]));
        }
        return this;
    }

    public void pretty() {
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder b = new StringBuilder();
            this.transitions.restart();
            while (this.transitions.hasNext()) {
                int t = this.transitions.next();
                b.append(" val(").append(t).append(") -> Dest(");
                b.append(this.delta[t].idx).append(")\n");
            }
            LOGGER.log(Level.INFO, "Noeud({0}):\n{1}", new Object[]{this.idx, b});
        }
    }

    public void toDotty(BufferedWriter bw) throws IOException {
        State[] delta2 = new State[this.delta.length];
        System.arraycopy(this.delta, 0, delta2, 0, this.delta.length);
        for (int i = 0; i < delta2.length; ++i) {
            if (delta2[i] == null) continue;
            StringBuilder label = new StringBuilder();
            label.append("   ").append(this.idx).append(" -> ").append(delta2[i].idx).append("  [ label = \"{").append(i);
            for (int j = i + 1; j < delta2.length; ++j) {
                if (delta2[j] == null || !delta2[i].equals(delta2[j])) continue;
                label.append("," + j);
                delta2[j] = null;
            }
            label.append("}\" ];");
            bw.write(label.toString());
            bw.newLine();
        }
    }
}

