% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_reset_control}
\alias{add_reset_control}
\title{Add a reset control to a map}
\usage{
add_reset_control(map, position = "top-right", animate = TRUE, duration = NULL)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{position}{The position of the control. Can be one of "top-left", "top-right", "bottom-left", or "bottom-right". Default is "top-right".}

\item{animate}{Whether or not to animate the transition to the original map view; defaults to \code{TRUE}.  If \code{FALSE}, the view will "jump" to the original view with no transition.}

\item{duration}{The length of the transition from the current view to the original view, specified in milliseconds.  This argument only works with \code{animate} is \code{TRUE}.}
}
\value{
The modified map object with the reset control added.
}
\description{
This function adds a reset control to a Mapbox GL or MapLibre GL map.
The reset control allows users to return to the original zoom level and center.
}
\examples{
\dontrun{
library(mapgl)

mapboxgl() |>
    add_reset_control(position = "top-left")
}
}
